/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#include <Dialog.h>        // Dialog class, Control.h, etc.
#include "ActiveXDLG.h"    // Resource IDs
 
#define AXD_NUM_COLS    2
#define AXD_NUM_ROWS    12

class CActiveXDlg : public Dialog
{
public:
	CActiveXDlg() : Dialog(IDD_AXD_ACTIVEX_DLG, "ActiveXDLG" )
	{
		
	}
	
	virtual int  DoModal(HWND hParent = NULL)
	{
		InitMsgMap();
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}
	
protected:
	
EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_BN_CLICKED( IDC_AXD_COMPUTE_BTN, OnClickComputeBTN )	
	ON_ACTIVEX_EVENT(21, IDC_AXD_VSFLEXGRID, OnBeforeEdit,  VTS_CTRL VTS_I4 VTS_I4 VTS_PBOOL)
EVENTS_END	
	
	// *** Event handler to initialize dialog ***
	BOOL OnInitDialog()
	{
		// ** Initialize grid **
		m_objActiveX = GetItem( IDC_AXD_VSFLEXGRID ).GetActiveXControl();		
		
		m_objActiveX.Cols = AXD_NUM_COLS;        // Set number of columns
		m_objActiveX.Rows = AXD_NUM_ROWS;        // Set number of rows
	
		m_objActiveX.FixedCols = 0;              // Hides row headings
		m_objActiveX.FixedRows = 1;              // One fixed row for column headings
	
		m_objActiveX.Row = 0;                    // Set Col 0 heading
		m_objActiveX.Col = 0;
		m_objActiveX.Text = (string)"Data";
	
		m_objActiveX.Col = 1;					// Set Col 1 heading
		m_objActiveX.Text = (string)"Include";	
	
		m_objActiveX.Editable = 2;               // Make grid editable in GUI
		
		// ** Initialize column values in grid **
		for(int ii = 1; ii < AXD_NUM_ROWS - 1; ii++)
		{
			m_objActiveX.Row = ii;
			m_objActiveX.Col = 0;
			m_objActiveX.Text = ii;              // Initialize Col 0 to integers 1 to 10
			m_objActiveX.Col = 1;
			m_objActiveX.CellChecked = 1;        // Make all cells in Col 1 be checkboxes and checked by default
		}
	
		// ** Format last row that contains sums ** 
		m_objActiveX.Row = ii;
		m_objActiveX.Col = 0;
		m_objActiveX.CellBackColor = RGB( 72, 216, 56 );
		m_objActiveX.Col = 1;
		m_objActiveX.CellBackColor = RGB( 72, 216, 56 );
		
		return TRUE;
	}
	
	
	// *** Event handler for OnClick of Compute button ***
	BOOL OnClickComputeBTN( Control ctrl )
	{		
		// ** Compute sum **
		double dSum = 0;
		int nChecks = 0;
		for( int ii = 1; ii < AXD_NUM_ROWS - 1; ii++ )
		{
			m_objActiveX.Row = ii;
			m_objActiveX.Col = 1;
			if( m_objActiveX.CellChecked == 1 )
			{
				nChecks += 1;
				m_objActiveX.Col = 0;
				dSum += m_objActiveX.Value;
			}
		}
		
		// ** Output sums in last row of grid **
		m_objActiveX.Row = ii;
		m_objActiveX.Col = 0;
		m_objActiveX.Text = dSum;
		m_objActiveX.Col = 1;
		m_objActiveX.Text = nChecks;
		
		return TRUE;
	}
	
	
	// ActiveX event handling	
	void OnBeforeEdit(Control cntrl, long nRow, long nCol, BOOL* pCancel)
	{		
		string strCombo = "1|2|3|4|5|6|7";
		string strNormalEdit = "";
	
		if(nRow > 9) // row 1-9 can edit, row 10 and up we show how to disable editing 
		{
			*pCancel = TRUE;
			return;
		}
		
		if(nCol == 0 && nRow > 5) // some rows we use combo box, some we don't
			m_objActiveX.ComboList = strCombo;
		else
			m_objActiveX.ComboList = strNormalEdit;	
	}
	
private:
	Object m_objActiveX;	// Define vsFlexGrid member variable 

};